#target premierepro-14.0
// Copyright 2014.  Adobe Systems, Incorporated.  All rights reserved.


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe Premiere Pro 2020.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe Premiere Pro 2020.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe Premiere Pro 2020 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe Premiere Pro 2020 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe Premiere Pro 2020 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe Premiere Pro 2020</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>"此指令碼能讓其他應用程式與 Adobe Premiere Pro 2020 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>"此脚本使其它应用程序能够与 Adobe Premiere Pro 2020 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Premiere Pro 2020</dc:title>
     <dc:description>"이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe Premiere Pro 2020과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/



premierepro14 = {};

premierepro14.premiereProTargetName = "premierepro-14.0";
premierepro14.premiereProAppName = "premierepro";
premierepro14.premiereProVersion = "14.2";
premierepro14.BridgeTargetName = "bridge";

/**
**	open
**
**	Open the passed in files. This may be one or many files.
**
*/
premierepro14.open = function(target)
{
	if (BridgeTalk.appSpecifier == premierepro14.premiereProTargetName)
	{
		var filePaths = [];

		for (var index = 0; index < target.length; index++)
		{
			filePaths[index] = target[index].fsName;
		}

		if (target.length == 1 && app.isDocument(filePaths))
		{
			app.openDocument(filePaths);
		}
		else if (app.isDocumentOpen())
		{
			document.importFiles(filePaths);
		}
	}
	else
	{
		var filesString = premierepro14.fileArrayToString(target);
		premierepro14.executeScript("premierepro14.open(" + filesString + ");");
	}
}

/**
**	executeScript
**
**	Execute the passed in script by sending a bridgetalk message.
*/
premierepro14.executeScript = function(script)
{
	if (BridgeTalk.appSpecifier == premierepro14.premiereProTargetName)
	{
		eval(script);
	}
	else
	{
		// Bring Premiere to the foreground.
		BridgeTalk.bringToFront(premierepro14.premiereProAppName);

		var btMessage = new BridgeTalk;
		btMessage.target = premierepro14.premiereProTargetName;
		btMessage.body = script;
		btMessage.send();
	}
}

/**
**	quit
**
**	Performs the equivalent of File>Exit.
*/
premierepro14.quit = function()
{
	if (BridgeTalk.appSpecifier == premierepro14.premiereProTargetName)
	{
		app.quit();
	}
	else
	{
		premierepro14.executeScript("app.quit();");
	}
}

/**
**	fileArrayToString
**
**	This routine create a string for the files array that we can transmit
**	over BridgeTalk as text, like this:
**
**	Array (File ('path1'), File ('path2'), File ('path3'))
*/
premierepro14.fileArrayToString = function(files)
{
	var filesString = new String("Array (");

	for (var index = 0; index < files.length; index++)
	{
		if (index > 0)
		{
			filesString += ", ";
		}

		filesString += "File ('" + files[index].absoluteURI.toString() + "')";
	}

	// close the Array
	filesString += ")";

	return filesString;
}

/**
**	Open Event
**
**	The event is:
**		event.type - document
**		event.location - document
**		event.object.constructor.name - Document
**		app.document.owner - premierepro-14.0
**
**	The app.document.owner is used to indicate that Bridge is in "slave" mode.
**	Used by applications that use Bridge for their own file browser.
**	Indicated in the window's title as "Opening in Adobe Premiere Pro 2020".
**
**	To get the selection use event.object.selections.
**
*/
premierepro14.eventHandler = function(event)
{
	var retval = {};
	retval.handled = false;

	if (event.type == "open"
		&& event.location == "document"
		&& event.object.constructor.name == "Document"
		&& app.document.owner == premierepro14.premiereProTargetName)
	{
		var sels = event.object.selections;
		var files = [];

		for (var i = 0; i < sels.length; i++)
		{
			files[i] = sels[i].spec;
		}

		if (files.length > 0)
		{
			premierepro14.open(files);
			retval.handled = true;
		}
	}

	return retval;
}

if (BridgeTalk.appName == premierepro14.BridgeTargetName)
{
	app.eventHandlers.push( {handler:premierepro14.eventHandler} );
}
